package com.ruoyi.websocket.interceptor;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.server.HandshakeInterceptor;

import java.util.List;
import java.util.Map;

//自定义握手阶段，需要进行身份验证 TODO
@Component
public class CustomHandshakeInterceptor implements HandshakeInterceptor {

	@Override
	public boolean beforeHandshake(ServerHttpRequest request, ServerHttpResponse response, WebSocketHandler wsHandler, Map<String, Object> attributes) throws Exception {
		// 在这里可以添加自定义的握手处理逻辑，比如身份验证
		System.out.println("正在进行握手处理...");

		// 获取请求头
		org.springframework.http.HttpHeaders headers = request.getHeaders();
		// 将请求头信息存储到 attributes 中
		attributes.put("headers", headers);
		return true;	
	}

	@Override
	public void afterHandshake(ServerHttpRequest request, ServerHttpResponse response, WebSocketHandler wsHandler, Exception exception) {
		// 握手完成后的处理逻辑
		System.out.println("握手完成");
	}
}
