package com.ruoyi.websocket;

import com.ruoyi.websocket.handler.SyncNotificationHandler;
import com.ruoyi.websocket.interceptor.CustomHandshakeInterceptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.socket.config.annotation.EnableWebSocket;
import org.springframework.web.socket.config.annotation.WebSocketConfigurer;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistry;
import org.springframework.web.socket.server.standard.ServletServerContainerFactoryBean;

@EnableWebSocket
@Configuration
public class WebSocketConfig implements WebSocketConfigurer {
	
	@Autowired
	CustomHandshakeInterceptor customHandshakeInterceptor;
	
	@Autowired
	SyncNotificationHandler syncNotificationHandler;
	
	@Override
	public void registerWebSocketHandlers(WebSocketHandlerRegistry registry) {
		registry.addHandler(syncNotificationHandler, "/ws")
				.setAllowedOrigins("*")
		        .addInterceptors(customHandshakeInterceptor);
	}

	@Bean
	public ServletServerContainerFactoryBean createWebSocketContainer() {
		ServletServerContainerFactoryBean container = new ServletServerContainerFactoryBean();
		// 设置发送超时时间为 5 秒
		container.setAsyncSendTimeout(5000L);
		
		return container;
	}

	
	
}
