package com.ruoyi.watch.service.impl;

import java.util.ArrayList;
import java.util.List;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.watch.domain.NmyUserWatchBase;
import com.ruoyi.watch.mapper.NmyUserWatchBaseMapper;
import com.ruoyi.websocket.dto.WebSocketMsgDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.watch.mapper.NmyUserWatchSubscribeMapper;
import com.ruoyi.watch.domain.NmyUserWatchSubscribe;
import com.ruoyi.watch.service.INmyUserWatchSubscribeService;
import org.springframework.util.CollectionUtils;

/**
 * 订阅的资源Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-04-29
 */
@Service
public class NmyUserWatchSubscribeServiceImpl implements INmyUserWatchSubscribeService 
{
    private static final Logger log = LoggerFactory.getLogger(NmyUserWatchSubscribeServiceImpl.class);
    @Autowired
    private NmyUserWatchSubscribeMapper nmyUserWatchSubscribeMapper;

    @Autowired
    private NmyUserWatchBaseMapper nmyUserWatchBaseMapper;
    /**
     * 查询订阅的资源
     * 
     * @param id 订阅的资源主键
     * @return 订阅的资源
     */
    @Override
    public NmyUserWatchSubscribe selectNmyUserWatchSubscribeById(Long id)
    {
        return nmyUserWatchSubscribeMapper.selectNmyUserWatchSubscribeById(id);
    }

    /**
     * 查询订阅的资源列表
     * 
     * @param nmyUserWatchSubscribe 订阅的资源
     * @return 订阅的资源
     */
    @Override
    public List<NmyUserWatchSubscribe> selectNmyUserWatchSubscribeList(NmyUserWatchSubscribe nmyUserWatchSubscribe)
    {
        return nmyUserWatchSubscribeMapper.selectNmyUserWatchSubscribeList(nmyUserWatchSubscribe);
    }

    /**
     * 新增订阅的资源
     * 
     * @param nmyUserWatchSubscribe 订阅的资源
     * @return 结果
     */
    @Override
    public int insertNmyUserWatchSubscribe(NmyUserWatchSubscribe nmyUserWatchSubscribe)
    {
        nmyUserWatchSubscribe.setCreateTime(DateUtils.getNowDate());
        return nmyUserWatchSubscribeMapper.insertNmyUserWatchSubscribe(nmyUserWatchSubscribe);
    }

    /**
     * 修改订阅的资源
     * 
     * @param nmyUserWatchSubscribe 订阅的资源
     * @return 结果
     */
    @Override
    public int updateNmyUserWatchSubscribe(NmyUserWatchSubscribe nmyUserWatchSubscribe)
    {
        return nmyUserWatchSubscribeMapper.updateNmyUserWatchSubscribe(nmyUserWatchSubscribe);
    }

    /**
     * 批量删除订阅的资源
     * 
     * @param ids 需要删除的订阅的资源主键
     * @return 结果
     */
    @Override
    public int deleteNmyUserWatchSubscribeByIds(Long[] ids)
    {
        return nmyUserWatchSubscribeMapper.deleteNmyUserWatchSubscribeByIds(ids);
    }

    /**
     * 删除订阅的资源信息
     * 
     * @param id 订阅的资源主键
     * @return 结果
     */
    @Override
    public int deleteNmyUserWatchSubscribeById(Long id)
    {
        return nmyUserWatchSubscribeMapper.deleteNmyUserWatchSubscribeById(id);
    }


    @Override
    public List<NmyUserWatchSubscribe> selectOnLingSubscriberByBaseId(Long watchBaseId) {
        return nmyUserWatchSubscribeMapper.selectOnLingSubscriberByBaseId(watchBaseId);
    }

    /**
     * 获取sessionKey,也就是要通知哪些客户端同步
     */
    @Override
    public List<WebSocketMsgDto> getWebSocketSendMsg(Long userId, Long deviceId, String changePath) {
                
        List<WebSocketMsgDto> result = new ArrayList<WebSocketMsgDto>();
        
        //获取资源
        NmyUserWatchBase nmyUserWatchBase = new NmyUserWatchBase();
        nmyUserWatchBase.setUserId(userId);
        nmyUserWatchBase.setDeviceId(deviceId);
        nmyUserWatchBase.setWatchPath(changePath);
        List<NmyUserWatchBase> nmyUserWatchBases = nmyUserWatchBaseMapper.selectNmyUserWatchBaseList(nmyUserWatchBase);
        
        if(CollectionUtils.isEmpty(nmyUserWatchBases)){
            log.error("userId:{},deviceId:{},changePath:{} , 没有查出来有基础资源不正确",userId,deviceId,changePath);
            return result;
        }
        NmyUserWatchBase nmyUserWatchBase1 = nmyUserWatchBases.get(0);
        Long watchBaseId = nmyUserWatchBase1.getId();
        
        //根据watchBaseId获取订阅他的在线的客户端  //TODO 应该加一个机制，不在线的不推送，如果人家上线了怎么整待定是直接同步还是没有变化就不同步
        List<NmyUserWatchSubscribe> nmyUserWatchSubscribes = selectOnLingSubscriberByBaseId(watchBaseId);
        
        //遍历返回结果
        nmyUserWatchSubscribes.forEach(nmyUserWatchSubscribe -> {
            WebSocketMsgDto webSocketMsgDto = new WebSocketMsgDto();
            webSocketMsgDto.setSessionKey(nmyUserWatchSubscribe.getUserId()+"_"+nmyUserWatchSubscribe.getDeviceId());
            webSocketMsgDto.setClientFilePath(nmyUserWatchSubscribe.getSyncPath());
            result.add(webSocketMsgDto);
        });
        return result;
    }
}
