package com.ruoyi.watch.service.impl;

import java.util.ArrayList;
import java.util.List;

import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.watch.mapper.NmyUserWatchBaseMapper;
import com.ruoyi.watch.domain.NmyUserWatchBase;
import com.ruoyi.watch.service.INmyUserWatchBaseService;

/**
 * 用户监控的路径(资源)Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-04-29
 */
@Service
public class NmyUserWatchBaseServiceImpl implements INmyUserWatchBaseService 
{
    @Autowired
    private NmyUserWatchBaseMapper nmyUserWatchBaseMapper;

    /**
     * 查询用户监控的路径(资源)
     * 
     * @param id 用户监控的路径(资源)主键
     * @return 用户监控的路径(资源)
     */
    @Override
    public NmyUserWatchBase selectNmyUserWatchBaseById(Long id)
    {
        return nmyUserWatchBaseMapper.selectNmyUserWatchBaseById(id);
    }

    /**
     * 查询用户监控的路径(资源)列表
     * 
     * @param nmyUserWatchBase 用户监控的路径(资源)
     * @return 用户监控的路径(资源)
     */
    @Override
    public List<NmyUserWatchBase> selectNmyUserWatchBaseList(NmyUserWatchBase nmyUserWatchBase)
    {
        return nmyUserWatchBaseMapper.selectNmyUserWatchBaseList(nmyUserWatchBase);
    }

    /**
     * 新增用户监控的路径(资源)
     * 
     * @param nmyUserWatchBase 用户监控的路径(资源)
     * @return 结果
     */
    @Override
    public int insertNmyUserWatchBase(NmyUserWatchBase nmyUserWatchBase)
    {
        nmyUserWatchBase.setCreateTime(DateUtils.getNowDate());
        return nmyUserWatchBaseMapper.insertNmyUserWatchBase(nmyUserWatchBase);
    }

    /**
     * 修改用户监控的路径(资源)
     * 
     * @param nmyUserWatchBase 用户监控的路径(资源)
     * @return 结果
     */
    @Override
    public int updateNmyUserWatchBase(NmyUserWatchBase nmyUserWatchBase)
    {
        return nmyUserWatchBaseMapper.updateNmyUserWatchBase(nmyUserWatchBase);
    }

    /**
     * 批量删除用户监控的路径(资源)
     * 
     * @param ids 需要删除的用户监控的路径(资源)主键
     * @return 结果
     */
    @Override
    public int deleteNmyUserWatchBaseByIds(Long[] ids)
    {
        return nmyUserWatchBaseMapper.deleteNmyUserWatchBaseByIds(ids);
    }

    /**
     * 删除用户监控的路径(资源)信息
     * 
     * @param id 用户监控的路径(资源)主键
     * @return 结果
     */
    @Override
    public int deleteNmyUserWatchBaseById(Long id)
    {
        return nmyUserWatchBaseMapper.deleteNmyUserWatchBaseById(id);
    }

    @Override
    public AjaxResult selectNmyUserWatchBaseList(Long userId, Long deviceId) {
        List<String> list = new ArrayList<String>();
        NmyUserWatchBase query = new NmyUserWatchBase();
        query.setUserId(userId);
        query.setDeviceId(deviceId);
        List<NmyUserWatchBase> nmyUserWatchBases = nmyUserWatchBaseMapper.selectNmyUserWatchBaseList(query);
        if(nmyUserWatchBases!=null && nmyUserWatchBases.size()>0){
            nmyUserWatchBases.forEach(nmyUserWatchBase->{
                list.add(nmyUserWatchBase.getWatchPath());
            });
          
        }
        return AjaxResult.success(list);
    }
}
