package com.ruoyi.watch.service;

import java.util.List;
import com.ruoyi.watch.domain.NmyUserWatchSubscribe;
import com.ruoyi.websocket.dto.WebSocketMsgDto;

/**
 * 订阅的资源Service接口
 * 
 * @author ruoyi
 * @date 2025-04-29
 */
public interface INmyUserWatchSubscribeService 
{
    /**
     * 查询订阅的资源
     * 
     * @param id 订阅的资源主键
     * @return 订阅的资源
     */
    public NmyUserWatchSubscribe selectNmyUserWatchSubscribeById(Long id);

    /**
     * 查询订阅的资源列表
     * 
     * @param nmyUserWatchSubscribe 订阅的资源
     * @return 订阅的资源集合
     */
    public List<NmyUserWatchSubscribe> selectNmyUserWatchSubscribeList(NmyUserWatchSubscribe nmyUserWatchSubscribe);

    /**
     * 新增订阅的资源
     * 
     * @param nmyUserWatchSubscribe 订阅的资源
     * @return 结果
     */
    public int insertNmyUserWatchSubscribe(NmyUserWatchSubscribe nmyUserWatchSubscribe);

    /**
     * 修改订阅的资源
     * 
     * @param nmyUserWatchSubscribe 订阅的资源
     * @return 结果
     */
    public int updateNmyUserWatchSubscribe(NmyUserWatchSubscribe nmyUserWatchSubscribe);

    /**
     * 批量删除订阅的资源
     * 
     * @param ids 需要删除的订阅的资源主键集合
     * @return 结果
     */
    public int deleteNmyUserWatchSubscribeByIds(Long[] ids);

    /**
     * 删除订阅的资源信息
     * 
     * @param id 订阅的资源主键
     * @return 结果
     */
    public int deleteNmyUserWatchSubscribeById(Long id);


    /**
     * 获取sessionKey,也就是要通知哪些客户端同步
     */
    public List<WebSocketMsgDto> getWebSocketSendMsg(Long userId, Long deviceId, String changePath);


    /**
     * 根据baseId 获取在线的 订阅者
     */
    public List<NmyUserWatchSubscribe> selectOnLingSubscriberByBaseId(Long watchBaseId);
    
}
