package com.ruoyi.watch.mapper;

import java.util.List;
import com.ruoyi.watch.domain.NmyUserWatchSubscribe;

/**
 * 订阅的资源Mapper接口
 * 
 * @author ruoyi
 * @date 2025-04-29
 */
public interface NmyUserWatchSubscribeMapper 
{
    /**
     * 查询订阅的资源
     * 
     * @param id 订阅的资源主键
     * @return 订阅的资源
     */
    public NmyUserWatchSubscribe selectNmyUserWatchSubscribeById(Long id);

    /**
     * 查询订阅的资源列表
     * 
     * @param nmyUserWatchSubscribe 订阅的资源
     * @return 订阅的资源集合
     */
    public List<NmyUserWatchSubscribe> selectNmyUserWatchSubscribeList(NmyUserWatchSubscribe nmyUserWatchSubscribe);
    /**
     * 根据baseId 获取在线的 订阅者
     */
    public List<NmyUserWatchSubscribe> selectOnLingSubscriberByBaseId(Long watchBaseId);
    /**
     * 新增订阅的资源
     * 
     * @param nmyUserWatchSubscribe 订阅的资源
     * @return 结果
     */
    public int insertNmyUserWatchSubscribe(NmyUserWatchSubscribe nmyUserWatchSubscribe);

    /**
     * 修改订阅的资源
     * 
     * @param nmyUserWatchSubscribe 订阅的资源
     * @return 结果
     */
    public int updateNmyUserWatchSubscribe(NmyUserWatchSubscribe nmyUserWatchSubscribe);

    /**
     * 删除订阅的资源
     * 
     * @param id 订阅的资源主键
     * @return 结果
     */
    public int deleteNmyUserWatchSubscribeById(Long id);

    /**
     * 批量删除订阅的资源
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteNmyUserWatchSubscribeByIds(Long[] ids);
}
