package com.ruoyi.watch.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 订阅的资源对象 nmy_user_watch_subscribe
 * 
 * @author ruoyi
 * @date 2025-04-29
 */
public class NmyUserWatchSubscribe extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    private Long id;

    /** 监控源id */
    @Excel(name = "监控源id")
    private Long watchBaseId;

    /** 用户id */
    @Excel(name = "用户id")
    private Long userId;

    /** 设备id */
    @Excel(name = "设备id")
    private Long deviceId;

    /** 对应的同步路径 */
    @Excel(name = "对应的同步路径")
    private String syncPath;

    /** 删除标志（0代表存在 2代表删除） */
    private String delFlag;

    public void setId(Long id) 
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }

    public void setWatchBaseId(Long watchBaseId) 
    {
        this.watchBaseId = watchBaseId;
    }

    public Long getWatchBaseId() 
    {
        return watchBaseId;
    }

    public void setUserId(Long userId) 
    {
        this.userId = userId;
    }

    public Long getUserId() 
    {
        return userId;
    }

    public void setDeviceId(Long deviceId) 
    {
        this.deviceId = deviceId;
    }

    public Long getDeviceId() 
    {
        return deviceId;
    }

    public void setSyncPath(String syncPath) 
    {
        this.syncPath = syncPath;
    }

    public String getSyncPath() 
    {
        return syncPath;
    }

    public void setDelFlag(String delFlag) 
    {
        this.delFlag = delFlag;
    }

    public String getDelFlag() 
    {
        return delFlag;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("watchBaseId", getWatchBaseId())
            .append("userId", getUserId())
            .append("deviceId", getDeviceId())
            .append("syncPath", getSyncPath())
            .append("createTime", getCreateTime())
            .append("delFlag", getDelFlag())
            .toString();
    }
}
