package com.ruoyi.user.service.impl;

import java.util.List;
import java.util.UUID;

import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.DeviceOnLineStatus;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.device.domain.NmyDevice;
import com.ruoyi.device.mapper.NmyDeviceMapper;
import com.ruoyi.device.service.INmyDeviceService;
import com.ruoyi.system.domain.SysUserOnline;
import com.ruoyi.user.dto.ClientUserOnline;
import com.ruoyi.user.dto.LoginDto;
import com.ruoyi.user.dto.RegisterDto;
import com.ruoyi.user.service.TokenApiService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.user.mapper.NmyUserMapper;
import com.ruoyi.user.domain.NmyUser;
import com.ruoyi.user.service.INmyUserService;
import org.springframework.util.CollectionUtils;

/**
 * 用户Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-04-29
 */
@Service
public class NmyUserServiceImpl implements INmyUserService 
{
    @Autowired
    private NmyUserMapper nmyUserMapper;
    
    @Autowired
    private INmyDeviceService nmyDeviceService;
	@Autowired
	private TokenApiService tokenApiService;

    /**
     * 查询用户
     * 
     * @param id 用户主键
     * @return 用户
     */
    @Override
    public NmyUser selectNmyUserById(Long id)
    {
        return nmyUserMapper.selectNmyUserById(id);
    }

    /**
     * 查询用户列表
     * 
     * @param nmyUser 用户
     * @return 用户
     */
    @Override
    public List<NmyUser> selectNmyUserList(NmyUser nmyUser)
    {
        return nmyUserMapper.selectNmyUserList(nmyUser);
    }

    /**
     * 新增用户
     * 
     * @param nmyUser 用户
     * @return 结果
     */
    @Override
    public int insertNmyUser(NmyUser nmyUser)
    {
        nmyUser.setCreateTime(DateUtils.getNowDate());
        return nmyUserMapper.insertNmyUser(nmyUser);
    }

    /**
     * 修改用户
     * 
     * @param nmyUser 用户
     * @return 结果
     */
    @Override
    public int updateNmyUser(NmyUser nmyUser)
    {
        nmyUser.setUpdateTime(DateUtils.getNowDate());
        return nmyUserMapper.updateNmyUser(nmyUser);
    }

    /**
     * 批量删除用户
     * 
     * @param ids 需要删除的用户主键
     * @return 结果
     */
    @Override
    public int deleteNmyUserByIds(Long[] ids)
    {
        return nmyUserMapper.deleteNmyUserByIds(ids);
    }

    /**
     * 删除用户信息
     * 
     * @param id 用户主键
     * @return 结果
     */
    @Override
    public int deleteNmyUserById(Long id)
    {
        return nmyUserMapper.deleteNmyUserById(id);
    }

    @Override
    public ClientUserOnline getUserOnline(Long deviceId) {
        NmyDevice nmyDevice = nmyDeviceService.selectNmyDeviceById(deviceId);
        if(nmyDevice == null){
            return null;
        }
        Long userId = nmyDevice.getUserId();
        
        NmyUser nmyUser = nmyUserMapper.selectNmyUserById(userId);
        if(nmyUser == null){
            return null;
        }
        ClientUserOnline clientUserOnline = new ClientUserOnline();
        clientUserOnline.setUserId(userId);
        clientUserOnline.setDeviceId(deviceId);
        clientUserOnline.setDeviceIp(nmyDevice.getDeviceIp());
        clientUserOnline.setDeviceFlag(nmyDevice.getDeviceFlag());
        clientUserOnline.setServerPath(nmyDevice.getServerPath());
        clientUserOnline.setToken(nmyDevice.getToken());
        return clientUserOnline;
    }
}
