package com.ruoyi.user.service.impl;

import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.DeviceOnLineStatus;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.device.domain.NmyDevice;
import com.ruoyi.device.service.INmyDeviceService;
import com.ruoyi.user.domain.NmyUser;
import com.ruoyi.user.dto.ClientUserOnline;
import com.ruoyi.user.dto.LoginDto;
import com.ruoyi.user.mapper.NmyUserMapper;
import com.ruoyi.user.service.INmyUserService;
import com.ruoyi.user.service.LoginService;
import com.ruoyi.user.service.TokenApiService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.UUID;

@Service("ClientLoginService")
public class ClientLoginServiceImpl implements LoginService {
	@Autowired
	private INmyDeviceService nmyDeviceService;
	@Autowired
	private TokenApiService tokenApiService;
	@Autowired
	private INmyUserService nmyUserService;

	@Override
	public AjaxResult login(LoginDto loginDto) {
		String phone = loginDto.getPhone();
		String code = loginDto.getCode();
		String deviceIp = loginDto.getDeviceIp();
		String deviceFlag = loginDto.getDeviceFlag();
		if(StringUtils.isEmpty(phone)){
			return AjaxResult.error("手机号未传");
		}
		if(StringUtils.isEmpty(code)){
			return AjaxResult.error("验证码未传");
		}

		//TODO 先注释功能完善在打开
		if(StringUtils.isEmpty(deviceIp)){
			return AjaxResult.error("设备ip未传");
		}
		if(StringUtils.isEmpty(deviceFlag)){
			return AjaxResult.error("设备唯一标识未传");
		}

		//根据手机号查用户存在不存在
		NmyUser queryUser = new NmyUser();
		queryUser.setPhoneNumber(phone);
		List<NmyUser> nmyUsers = nmyUserService.selectNmyUserList(queryUser);
		if(CollectionUtils.isEmpty(nmyUsers)){
			return AjaxResult.error("用户不存在");
		}


		// TODO 验证码先写死123456，其实应该在redis中拿取，进行对比
		if(!code.equals("123456")){
			return AjaxResult.error("登陆失败，验证码错误");
		}

		//验证通过进行登陆
		NmyUser nmyUser = nmyUsers.get(0);

		//查询设备的唯一标识在数据库中是否存在，如果不存在需要向数据库插入一条，如果已存在需要更新设备的ip，正常注册的时候就应该保存，但是ip可能会变
		NmyDevice nmyDeviceQueryParam = new NmyDevice();
		nmyDeviceQueryParam.setDeviceFlag(deviceFlag);
		nmyDeviceQueryParam.setUserId(nmyUser.getId());
		List<NmyDevice> nmyDevices = nmyDeviceService.selectNmyDeviceList(nmyDeviceQueryParam);


		NmyDevice insertDevice = null;
		if(CollectionUtils.isEmpty(nmyDevices)){
			//数据库中没有这个设备，说明用户可能登陆了新的设备，需要插入
			insertDevice = new NmyDevice();
			insertDevice.setDeviceFlag(deviceFlag);
			insertDevice.setUserId(nmyUser.getId());
			insertDevice.setOnLine(DeviceOnLineStatus.on_line.getCode());
			insertDevice.setDeviceIp(deviceIp);
			insertDevice.setCreateTime(DateUtils.getNowDate());
			insertDevice.setUpdateTime(DateUtils.getNowDate());
            insertDevice.setServerPath(UUID.randomUUID().toString());
			nmyDeviceService.insertNmyDevice(insertDevice);
		}else {
			//存在需要比对ip变没变，如果有变化需要更新
			insertDevice = nmyDevices.get(0);
			if(!insertDevice.getDeviceIp().equals(deviceIp)){
				//更新ip,并且设置成上线
				insertDevice.setDeviceIp(deviceIp);
				insertDevice.setOnLine(DeviceOnLineStatus.on_line.getCode());
				nmyDeviceService.updateNmyDevice(insertDevice);
			}
		}

		String serverPath = insertDevice.getServerPath();
		//生成token
		ClientUserOnline clientUserOnline = new ClientUserOnline();
		clientUserOnline.setUserId(nmyUser.getId());
		clientUserOnline.setDeviceId(insertDevice.getId());
		clientUserOnline.setDeviceIp(deviceIp);
		clientUserOnline.setServerPath(serverPath);
		clientUserOnline.setDeviceFlag(deviceFlag);

		String token = tokenApiService.createToken(clientUserOnline);
		//更新token
		NmyDevice updateToken  = new NmyDevice();
		updateToken.setToken(token);
		updateToken.setId(insertDevice.getId());
		int i = nmyDeviceService.updateNmyDevice(updateToken);

		clientUserOnline.setToken(token);
		
		return AjaxResult.success(clientUserOnline);
	}
}
