package com.ruoyi.user.domain;

import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 用户对象 nmy_user
 * 
 * @author ruoyi
 * @date 2025-04-29
 */
@Data
public class NmyUser extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    private Long id;

    /** 电话 */
    @Excel(name = "电话")
    private String phoneNumber;

    /** 密码 */
    @Excel(name = "密码")
    private String password;
    

    
    /** 删除标志（0代表存在 2代表删除） */
    private String delFlag;


    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("phoneNumber", getPhoneNumber())
            .append("password", getPassword())
            .append("delFlag", getDelFlag())
            .append("createTime", getCreateTime())
            .append("updateTime", getUpdateTime())
            .toString();
    }
}
