package com.ruoyi.device.service.impl;

import java.util.List;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.device.mapper.NmyDeviceMapper;
import com.ruoyi.device.domain.NmyDevice;
import com.ruoyi.device.service.INmyDeviceService;

/**
 * 设备Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-04-29
 */
@Service
public class NmyDeviceServiceImpl implements INmyDeviceService 
{
    @Autowired
    private NmyDeviceMapper nmyDeviceMapper;

    
    
    /**
     * 查询设备
     * 
     * @param id 设备主键
     * @return 设备
     */
    @Override
    public NmyDevice selectNmyDeviceById(Long id)
    {
        return nmyDeviceMapper.selectNmyDeviceById(id);
    }

    /**
     * 查询设备列表
     * 
     * @param nmyDevice 设备
     * @return 设备
     */
    @Override
    public List<NmyDevice> selectNmyDeviceList(NmyDevice nmyDevice)
    {
        return nmyDeviceMapper.selectNmyDeviceList(nmyDevice);
    }

    /**
     * 新增设备
     * 
     * @param nmyDevice 设备
     * @return 结果
     */
    @Override
    public int insertNmyDevice(NmyDevice nmyDevice)
    {
        nmyDevice.setCreateTime(DateUtils.getNowDate());
        return nmyDeviceMapper.insertNmyDevice(nmyDevice);
    }

    /**
     * 修改设备
     * 
     * @param nmyDevice 设备
     * @return 结果
     */
    @Override
    public int updateNmyDevice(NmyDevice nmyDevice)
    {
        nmyDevice.setUpdateTime(DateUtils.getNowDate());
        return nmyDeviceMapper.updateNmyDevice(nmyDevice);
    }

    /**
     * 批量删除设备
     * 
     * @param ids 需要删除的设备主键
     * @return 结果
     */
    @Override
    public int deleteNmyDeviceByIds(Long[] ids)
    {
        return nmyDeviceMapper.deleteNmyDeviceByIds(ids);
    }

    /**
     * 删除设备信息
     * 
     * @param id 设备主键
     * @return 结果
     */
    @Override
    public int deleteNmyDeviceById(Long id)
    {
        return nmyDeviceMapper.deleteNmyDeviceById(id);
    }
    
    
    /**
     * 上线
     *
     * @param deviceId 设备主键
     * @return 结果
     */
    @Override
    public void onLine(Long deviceId,String online) {
        NmyDevice nmyDevice = new NmyDevice();
        nmyDevice.setId(deviceId);
        nmyDevice.setOnLine(online);
        nmyDevice.setUpdateTime(DateUtils.getNowDate());
        nmyDeviceMapper.updateNmyDevice(nmyDevice);
    }
}
