package com.ruoyi.device.mapper;

import java.util.List;
import com.ruoyi.device.domain.NmyDevice;

/**
 * 设备Mapper接口
 * 
 * @author ruoyi
 * @date 2025-04-29
 */
public interface NmyDeviceMapper 
{
    /**
     * 查询设备
     * 
     * @param id 设备主键
     * @return 设备
     */
    public NmyDevice selectNmyDeviceById(Long id);

    /**
     * 查询设备列表
     * 
     * @param nmyDevice 设备
     * @return 设备集合
     */
    public List<NmyDevice> selectNmyDeviceList(NmyDevice nmyDevice);

    /**
     * 新增设备
     * 
     * @param nmyDevice 设备
     * @return 结果
     */
    public int insertNmyDevice(NmyDevice nmyDevice);

    /**
     * 修改设备
     * 
     * @param nmyDevice 设备
     * @return 结果
     */
    public int updateNmyDevice(NmyDevice nmyDevice);

    /**
     * 删除设备
     * 
     * @param id 设备主键
     * @return 结果
     */
    public int deleteNmyDeviceById(Long id);

    /**
     * 批量删除设备
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteNmyDeviceByIds(Long[] ids);
}
