package com.ruoyi.device.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.device.domain.NmyDevice;
import com.ruoyi.device.service.INmyDeviceService;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;

/**
 * 设备Controller
 * 
 * @author ruoyi
 * @date 2025-04-29
 */
@RestController
@RequestMapping("/device/device")
public class NmyDeviceController extends BaseController
{
    @Autowired
    private INmyDeviceService nmyDeviceService;

    /**
     * 查询设备列表
     */
    @PreAuthorize("@ss.hasPermi('device:device:list')")
    @GetMapping("/list")
    public TableDataInfo list(NmyDevice nmyDevice)
    {
        startPage();
        List<NmyDevice> list = nmyDeviceService.selectNmyDeviceList(nmyDevice);
        return getDataTable(list);
    }

    /**
     * 导出设备列表
     */
    @PreAuthorize("@ss.hasPermi('device:device:export')")
    @Log(title = "设备", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, NmyDevice nmyDevice)
    {
        List<NmyDevice> list = nmyDeviceService.selectNmyDeviceList(nmyDevice);
        ExcelUtil<NmyDevice> util = new ExcelUtil<NmyDevice>(NmyDevice.class);
        util.exportExcel(response, list, "设备数据");
    }

    /**
     * 获取设备详细信息
     */
    @PreAuthorize("@ss.hasPermi('device:device:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(nmyDeviceService.selectNmyDeviceById(id));
    }

    /**
     * 新增设备
     */
    @PreAuthorize("@ss.hasPermi('device:device:add')")
    @Log(title = "设备", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody NmyDevice nmyDevice)
    {
        return toAjax(nmyDeviceService.insertNmyDevice(nmyDevice));
    }

    /**
     * 修改设备
     */
    @PreAuthorize("@ss.hasPermi('device:device:edit')")
    @Log(title = "设备", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody NmyDevice nmyDevice)
    {
        return toAjax(nmyDeviceService.updateNmyDevice(nmyDevice));
    }

    /**
     * 删除设备
     */
    @PreAuthorize("@ss.hasPermi('device:device:remove')")
    @Log(title = "设备", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(nmyDeviceService.deleteNmyDeviceByIds(ids));
    }
}
