package com.ruoyi.async;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

/**
* @return 
* @Version: v1.0
* @Author: LiuYan
* @Date 2025-4-30 15:49
 * 
 * 线程池配置，使用websocket发送消息的时候使用异步线程，用线程池
 * 
**/
@Configuration
@ConfigurationProperties(prefix = "task.pool.ws-send-msg")
public class WebSocketSendMsgThreadPollConfig {
	private int corePoolSize;
	private int maxPoolSize;
	private int queueCapacity;
	private int keepAliveSeconds;
	private boolean allowCoreTimeout;
	private String threadNamePrefix;

	public int getCorePoolSize() {
		return corePoolSize;
	}

	public void setCorePoolSize(int corePoolSize) {
		this.corePoolSize = corePoolSize;
	}

	public int getMaxPoolSize() {
		return maxPoolSize;
	}

	public void setMaxPoolSize(int maxPoolSize) {
		this.maxPoolSize = maxPoolSize;
	}

	public int getQueueCapacity() {
		return queueCapacity;
	}

	public void setQueueCapacity(int queueCapacity) {
		this.queueCapacity = queueCapacity;
	}

	public int getKeepAliveSeconds() {
		return keepAliveSeconds;
	}

	public void setKeepAliveSeconds(int keepAliveSeconds) {
		this.keepAliveSeconds = keepAliveSeconds;
	}

	public boolean isAllowCoreTimeout() {
		return allowCoreTimeout;
	}

	public void setAllowCoreTimeout(boolean allowCoreTimeout) {
		this.allowCoreTimeout = allowCoreTimeout;
	}

	public String getThreadNamePrefix() {
		return threadNamePrefix;
	}

	public void setThreadNamePrefix(String threadNamePrefix) {
		this.threadNamePrefix = threadNamePrefix;
	}
}
