package com.ruoyi.async;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;

@Configuration
@EnableAsync
public class AsyncConfig {
	
	@Autowired
	WebSocketSendMsgThreadPollConfig pollConfig;
	
	@Bean(name = "webSocketSendMsgThreadPoll")
	public Executor taskExecutor() {
		ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
		executor.setCorePoolSize(pollConfig.getCorePoolSize());
		executor.setMaxPoolSize(pollConfig.getMaxPoolSize());
		executor.setQueueCapacity(pollConfig.getQueueCapacity());
		executor.setThreadNamePrefix(pollConfig.getThreadNamePrefix());
		executor.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
		executor.setKeepAliveSeconds(pollConfig.getKeepAliveSeconds());
		executor.setAllowCoreThreadTimeOut(true);

		// 关键配置：优雅关闭
		executor.setWaitForTasksToCompleteOnShutdown(true); // 等待所有任务完成
		executor.setAwaitTerminationSeconds(30);            // 最多等待30秒
		
		executor.initialize();
		return executor;
	}
	
}
