package com.ruoyi.common.utils;

import java.io.IOException;
import java.nio.file.*;
import java.nio.file.attribute.BasicFileAttributes;

public class MyFileUtils {

	//创建文件夹
	public static boolean createDirectoryUsingPath(String directoryPath) {
		Path path = Paths.get(directoryPath);
		try {
			// 创建目录，如果父目录不存在会抛出异常
			// Files.createDirectory(path); 
			// 创建目录，如果父目录不存在会一并创建
			Files.createDirectories(path);
			return true;
		} catch (IOException e) {
			e.printStackTrace();
			return false;
		}
	}

	
	//删除文件夹
	public static boolean deleteDirectory(String url) {
		try {
			Path directory = Paths.get(url);
			Files.walkFileTree(directory, new SimpleFileVisitor<Path>() {
				@Override
				public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
					// 删除文件
					Files.delete(file);
					return FileVisitResult.CONTINUE;
				}

				@Override
				public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
					if (exc == null) {
						// 删除空目录
						Files.delete(dir);
						return FileVisitResult.CONTINUE;
					}
					throw exc;
				}
			});
			return true;
		}catch (Exception e){
			
			e.printStackTrace();
			return false;
		}
	}
	
	//删除文件
	public static boolean deleteFile(String filePath) {
		// 指定要删除的文件路径
		Path path = Paths.get(filePath);
		try {
			// 尝试删除文件，如果文件不存在则抛出异常
			// Files.delete(path); 
			// 尝试删除文件，如果文件不存在则不会抛出异常
			if (Files.deleteIfExists(path)) {
				System.out.println("文件删除成功");
				return true;
			} else {
				System.out.println("文件不存在");
				return true;
			}
		} catch (IOException e) {
			System.out.println("文件删除失败: " + e.getMessage());
			return false;
		}
	}

	//重命名文件
	public static boolean renameFile(String oldFilePath, String newFilePath) {
		// 创建代表旧文件的 Path 对象
		Path oldPath = Paths.get(oldFilePath);
		// 创建代表新文件的 Path 对象
		Path newPath = Paths.get(newFilePath);

		try {
			// 调用 Files.move 方法重命名文件
			Files.move(oldPath, newPath, StandardCopyOption.REPLACE_EXISTING);
			return true;
		} catch (IOException e) {
			e.printStackTrace();
			return false;
		}
	}
	
	
}
