package com.ruoyi.client.server;

import com.ruoyi.client.service.FileServiceImpl;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

//自己实现的grpc服务类
@Component
public class GrpcFileServer {
	
	@Autowired
	private FileServiceImpl fileServiceImpl;
	
	public void initServer(){
		try {
			// 创建服务实例
			Server server = ServerBuilder.forPort(50051)
					.addService(fileServiceImpl) // 关键控制器注册
					.build();

			server.start();
			System.out.println("Server started on port 50051");

			Runtime.getRuntime().addShutdownHook(new Thread(() -> {
				//当JVM关闭时回调钩子，关闭grpc服务
				server.shutdown();
				System.out.println("Server stopped");
			}));

			//保持主进程不退出持续监控
			server.awaitTermination();
		}catch (Exception e){
			e.printStackTrace();
		}
	}
	
}
