package com.ruoyi.client.service;

import com.google.protobuf.ByteString;
import com.ruoyi.grpc.file.*;
import io.grpc.stub.StreamObserver;
import org.springframework.stereotype.Service;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

@Service
public class FileServiceImpl extends FileServiceGrpc.FileServiceImplBase {
	
	@Override
	public StreamObserver<FileUploadRequest> uploadFile(StreamObserver<FileUploadResponse> responseObserver) {
		return new StreamObserver<FileUploadRequest>() {
			private String filename;
			private FileOutputStream fos;
			private long totalSize = 0;

			@Override
			public void onNext(FileUploadRequest request) {
				if (request.hasFilename()) {
					filename = request.getFilename();
					try {
						fos = new FileOutputStream("server_files/" + filename);
					} catch (IOException e) {
						responseObserver.onError(e);
					}
				} else {
					try {
						byte[] chunk = request.getChunk().toByteArray();
						totalSize += chunk.length;
						fos.write(chunk);
					} catch (IOException e) {
						responseObserver.onError(e);
					}
				}
			}

			@Override
			public void onError(Throwable t) {
				System.err.println("Upload failed: " + t.getMessage());
			}

			@Override
			public void onCompleted() {
				try {
					fos.close();
					responseObserver.onNext(FileUploadResponse.newBuilder()
							.setStatus("Success")
							.setSize(totalSize)
							.build());
					responseObserver.onCompleted();
				} catch (IOException e) {
					responseObserver.onError(e);
				}
			}
		};
	}



	@Override
	public void downloadFile(FileDownloadRequest request,
	                         StreamObserver<FileDownloadResponse> responseObserver) {
		try {

			java.io.File file = new java.io.File("server_files/" + request.getFilename());
			FileInputStream fis = new FileInputStream(file);
			byte[] buffer = new byte[64 * 1024]; // 64KB chunks
			int bytesRead;

			while ((bytesRead = fis.read(buffer)) != -1) {
				responseObserver.onNext(FileDownloadResponse.newBuilder()
						.setChunk(ByteString.copyFrom(buffer, 0, bytesRead))
						.build());
			}
			fis.close();
			responseObserver.onCompleted();
		} catch (IOException e) {
			responseObserver.onError(e);
		}
	}
	
	
}
