package com.ruoyi.websocket.service;

import com.google.gson.Gson;
import com.ruoyi.websocket.dto.WebSocketMsgDto;
import com.ruoyi.websocket.handler.SyncNotificationHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;

@Service
public class WebSocketService {
	
	@Autowired
	private SyncNotificationHandler syncNotificationHandler;


	@Async("webSocketSendMsgThreadPoll")
	public void sendMsg(List<WebSocketMsgDto> webSocketSendMsg) {
		for (WebSocketMsgDto webSocketMsgDto : webSocketSendMsg) {
			Gson gson = new Gson();
			String msg = gson.toJson(webSocketMsgDto);
			syncNotificationHandler.notifyClient(webSocketMsgDto.getSessionKey(),msg);
		}	
	}
	
	
}
