package com.ruoyi.watch.mapper;

import java.util.List;
import com.ruoyi.watch.domain.NmyUserWatchBase;

/**
 * 用户监控的路径(资源)Mapper接口
 * 
 * @author ruoyi
 * @date 2025-04-29
 */
public interface NmyUserWatchBaseMapper 
{
    /**
     * 查询用户监控的路径(资源)
     * 
     * @param id 用户监控的路径(资源)主键
     * @return 用户监控的路径(资源)
     */
    public NmyUserWatchBase selectNmyUserWatchBaseById(Long id);

    /**
     * 查询用户监控的路径(资源)列表
     * 
     * @param nmyUserWatchBase 用户监控的路径(资源)
     * @return 用户监控的路径(资源)集合
     */
    public List<NmyUserWatchBase> selectNmyUserWatchBaseList(NmyUserWatchBase nmyUserWatchBase);

    /**
     * 新增用户监控的路径(资源)
     * 
     * @param nmyUserWatchBase 用户监控的路径(资源)
     * @return 结果
     */
    public int insertNmyUserWatchBase(NmyUserWatchBase nmyUserWatchBase);

    /**
     * 修改用户监控的路径(资源)
     * 
     * @param nmyUserWatchBase 用户监控的路径(资源)
     * @return 结果
     */
    public int updateNmyUserWatchBase(NmyUserWatchBase nmyUserWatchBase);

    /**
     * 删除用户监控的路径(资源)
     * 
     * @param id 用户监控的路径(资源)主键
     * @return 结果
     */
    public int deleteNmyUserWatchBaseById(Long id);

    /**
     * 批量删除用户监控的路径(资源)
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteNmyUserWatchBaseByIds(Long[] ids);
}
