package com.ruoyi.watch.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.watch.domain.NmyUserWatchSubscribe;
import com.ruoyi.watch.service.INmyUserWatchSubscribeService;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;

/**
 * 订阅的资源Controller
 * 
 * @author ruoyi
 * @date 2025-04-29
 */
@RestController
@RequestMapping("/watch/watchSubscribe")
public class NmyUserWatchSubscribeController extends BaseController
{
    @Autowired
    private INmyUserWatchSubscribeService nmyUserWatchSubscribeService;

    /**
     * 查询订阅的资源列表
     */
    @PreAuthorize("@ss.hasPermi('watch:watchSubscribe:list')")
    @GetMapping("/list")
    public TableDataInfo list(NmyUserWatchSubscribe nmyUserWatchSubscribe)
    {
        startPage();
        List<NmyUserWatchSubscribe> list = nmyUserWatchSubscribeService.selectNmyUserWatchSubscribeList(nmyUserWatchSubscribe);
        return getDataTable(list);
    }

    /**
     * 导出订阅的资源列表
     */
    @PreAuthorize("@ss.hasPermi('watch:watchSubscribe:export')")
    @Log(title = "订阅的资源", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, NmyUserWatchSubscribe nmyUserWatchSubscribe)
    {
        List<NmyUserWatchSubscribe> list = nmyUserWatchSubscribeService.selectNmyUserWatchSubscribeList(nmyUserWatchSubscribe);
        ExcelUtil<NmyUserWatchSubscribe> util = new ExcelUtil<NmyUserWatchSubscribe>(NmyUserWatchSubscribe.class);
        util.exportExcel(response, list, "订阅的资源数据");
    }

    /**
     * 获取订阅的资源详细信息
     */
    @PreAuthorize("@ss.hasPermi('watch:watchSubscribe:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(nmyUserWatchSubscribeService.selectNmyUserWatchSubscribeById(id));
    }

    /**
     * 新增订阅的资源
     */
    @PreAuthorize("@ss.hasPermi('watch:watchSubscribe:add')")
    @Log(title = "订阅的资源", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody NmyUserWatchSubscribe nmyUserWatchSubscribe)
    {
        return toAjax(nmyUserWatchSubscribeService.insertNmyUserWatchSubscribe(nmyUserWatchSubscribe));
    }

    /**
     * 修改订阅的资源
     */
    @PreAuthorize("@ss.hasPermi('watch:watchSubscribe:edit')")
    @Log(title = "订阅的资源", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody NmyUserWatchSubscribe nmyUserWatchSubscribe)
    {
        return toAjax(nmyUserWatchSubscribeService.updateNmyUserWatchSubscribe(nmyUserWatchSubscribe));
    }

    /**
     * 删除订阅的资源
     */
    @PreAuthorize("@ss.hasPermi('watch:watchSubscribe:remove')")
    @Log(title = "订阅的资源", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(nmyUserWatchSubscribeService.deleteNmyUserWatchSubscribeByIds(ids));
    }
}
