package com.ruoyi.watch.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.watch.domain.NmyUserWatchBase;
import com.ruoyi.watch.service.INmyUserWatchBaseService;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;

/**
 * 用户监控的路径(资源)Controller
 * 
 * @author ruoyi
 * @date 2025-04-29
 */
@RestController
@RequestMapping("/watch/watchBase")
public class NmyUserWatchBaseController extends BaseController
{
    @Autowired
    private INmyUserWatchBaseService nmyUserWatchBaseService;

    /**
     * 查询用户监控的路径(资源)列表
     */
    @PreAuthorize("@ss.hasPermi('watch:watchBase:list')")
    @GetMapping("/list")
    public TableDataInfo list(NmyUserWatchBase nmyUserWatchBase)
    {
        startPage();
        List<NmyUserWatchBase> list = nmyUserWatchBaseService.selectNmyUserWatchBaseList(nmyUserWatchBase);
        return getDataTable(list);
    }

    /**
     * 导出用户监控的路径(资源)列表
     */
    @PreAuthorize("@ss.hasPermi('watch:watchBase:export')")
    @Log(title = "用户监控的路径(资源)", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, NmyUserWatchBase nmyUserWatchBase)
    {
        List<NmyUserWatchBase> list = nmyUserWatchBaseService.selectNmyUserWatchBaseList(nmyUserWatchBase);
        ExcelUtil<NmyUserWatchBase> util = new ExcelUtil<NmyUserWatchBase>(NmyUserWatchBase.class);
        util.exportExcel(response, list, "用户监控的路径(资源)数据");
    }

    /**
     * 获取用户监控的路径(资源)详细信息
     */
    @PreAuthorize("@ss.hasPermi('watch:watchBase:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(nmyUserWatchBaseService.selectNmyUserWatchBaseById(id));
    }

    /**
     * 新增用户监控的路径(资源)
     */
    @PreAuthorize("@ss.hasPermi('watch:watchBase:add')")
    @Log(title = "用户监控的路径(资源)", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody NmyUserWatchBase nmyUserWatchBase)
    {
        return toAjax(nmyUserWatchBaseService.insertNmyUserWatchBase(nmyUserWatchBase));
    }

    /**
     * 修改用户监控的路径(资源)
     */
    @PreAuthorize("@ss.hasPermi('watch:watchBase:edit')")
    @Log(title = "用户监控的路径(资源)", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody NmyUserWatchBase nmyUserWatchBase)
    {
        return toAjax(nmyUserWatchBaseService.updateNmyUserWatchBase(nmyUserWatchBase));
    }

    /**
     * 删除用户监控的路径(资源)
     */
    @PreAuthorize("@ss.hasPermi('watch:watchBase:remove')")
    @Log(title = "用户监控的路径(资源)", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(nmyUserWatchBaseService.deleteNmyUserWatchBaseByIds(ids));
    }
}
