package com.ruoyi.user.service.impl;

import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.DeviceOnLineStatus;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.device.domain.NmyDevice;
import com.ruoyi.device.service.INmyDeviceService;
import com.ruoyi.user.domain.NmyUser;
import com.ruoyi.user.dto.RegisterDto;
import com.ruoyi.user.mapper.NmyUserMapper;
import com.ruoyi.user.service.INmyUserService;
import com.ruoyi.user.service.RegisterService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.UUID;

@Service("RegisterService")
public class ClientRegisterServiceImpl implements RegisterService {
	
	@Autowired
	private INmyUserService nmyUserService;
	@Autowired
	private INmyDeviceService nmyDeviceService;
	/**
	 * 注册
	 *
	 * @param registerDto 注册
	 * @return 结果
	 */
	@Override
	public AjaxResult register(RegisterDto registerDto) {
		String phone = registerDto.getPhone();
		String password = registerDto.getPassword();
		String code = registerDto.getCode();

		String deviceFlag = registerDto.getDeviceFlag();
		String deviceIp = registerDto.getDeviceIp();

		if(StringUtils.isEmpty(phone) || StringUtils.isEmpty(password) || StringUtils.isEmpty(code)){
			return AjaxResult.error("登陆参数不完整");
		}
		if(StringUtils.isEmpty(deviceFlag) || StringUtils.isEmpty(deviceIp)){
			return AjaxResult.error("设备参数缺失");
		}
		//todo 手机号校验格式，发送验证码的时候校验手机号是否已注册，验证码校验，密码加密
		//保存用户
		NmyUser saveUser = new NmyUser();
		saveUser.setPhoneNumber(phone);
		saveUser.setPassword(password);
		
		int i = nmyUserService.insertNmyUser(saveUser);

		//保存设备信息
		NmyDevice deviceInfo = new NmyDevice();
		deviceInfo.setUserId(saveUser.getId());
		deviceInfo.setDeviceIp(deviceIp);
		deviceInfo.setDeviceFlag(deviceFlag);
		deviceInfo.setOnLine(DeviceOnLineStatus.off_line.getCode());
		String serverPath = UUID.randomUUID().toString();
		deviceInfo.setServerPath(serverPath);
		
		nmyDeviceService.insertNmyDevice(deviceInfo);
		return AjaxResult.success();
	}

}
