package com.ruoyi.user.service;

import com.ruoyi.common.constant.Constants;
import com.ruoyi.common.constant.NmyConstans;
import com.ruoyi.common.utils.ServletUtils;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.user.dto.ClientUserOnline;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpHeaders;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.socket.WebSocketSession;

import javax.servlet.http.HttpServletRequest;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@Service
public class WebSocketTokenApiService {
	
	
	private static final Logger log = LoggerFactory.getLogger(WebSocketTokenApiService.class);
	// 令牌秘钥
	@Value("${tokenapi.secret}")
	private String secret;

	// 令牌自定义标识
	@Value("${tokenapi.header}")
	private String header;

	@Autowired
	private INmyUserService nmyUserService;
	/**
	 * 从令牌中获取数据声明
	 *
	 * @param token 令牌
	 * @return 数据声明
	 */
	public Claims parseToken(String token)
	{
		return Jwts.parser()
				.setSigningKey(secret)
				.parseClaimsJws(token)
				.getBody();
	}
	
	
	public ClientUserOnline getLoginUser(WebSocketSession session){
		String token = getToken(session);
		if (StringUtils.isNotEmpty(token))
		{
			try
			{
				Claims claims = parseToken(token);
				Long deviceId = claims.get(NmyConstans.deviceId, Long.class);
				ClientUserOnline userOnline = nmyUserService.getUserOnline(deviceId);
				return userOnline;
			}
			catch (Exception e)
			{
				log.error(e.getMessage(),e);
			}
		}
		return null;
	}

	/**
	 * 获取请求token
	 *
	 * @return token
	 */
	public String getToken(WebSocketSession session)
	{
		Map<String, Object> attributes = session.getAttributes();
		HttpHeaders headers = (HttpHeaders) attributes.get("headers");
		List<String> strings = headers.get("authorization");
		if(CollectionUtils.isEmpty(strings)){
			return "";
		}
		String token = strings.get(0);
		if (StringUtils.isNotEmpty(token) && token.startsWith(Constants.TOKEN_PREFIX))
		{
			token = token.replace(Constants.TOKEN_PREFIX, "");
		}
		return token;
	}
	
}
