package com.ruoyi.user.service;

import java.util.List;

import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.user.domain.NmyUser;
import com.ruoyi.user.dto.ClientUserOnline;
import com.ruoyi.user.dto.LoginDto;
import com.ruoyi.user.dto.RegisterDto;

/**
 * 用户Service接口
 * 
 * @author ruoyi
 * @date 2025-04-29
 */
public interface INmyUserService 
{
    /**
     * 查询用户
     * 
     * @param id 用户主键
     * @return 用户
     */
    public NmyUser selectNmyUserById(Long id);

    /**
     * 查询用户列表
     * 
     * @param nmyUser 用户
     * @return 用户集合
     */
    public List<NmyUser> selectNmyUserList(NmyUser nmyUser);

    /**
     * 新增用户
     * 
     * @param nmyUser 用户
     * @return 结果
     */
    public int insertNmyUser(NmyUser nmyUser);

    /**
     * 修改用户
     * 
     * @param nmyUser 用户
     * @return 结果
     */
    public int updateNmyUser(NmyUser nmyUser);

    /**
     * 批量删除用户
     * 
     * @param ids 需要删除的用户主键集合
     * @return 结果
     */
    public int deleteNmyUserByIds(Long[] ids);

    /**
     * 删除用户信息
     * 
     * @param id 用户主键
     * @return 结果
     */
    public int deleteNmyUserById(Long id);
    
    
    public ClientUserOnline getUserOnline(Long deviceId);
    

}
