package com.ruoyi.user.mapper;

import java.util.List;
import com.ruoyi.user.domain.NmyUser;

/**
 * 用户Mapper接口
 * 
 * @author ruoyi
 * @date 2025-04-29
 */
public interface NmyUserMapper 
{
    /**
     * 查询用户
     * 
     * @param id 用户主键
     * @return 用户
     */
    public NmyUser selectNmyUserById(Long id);

    /**
     * 查询用户列表
     * 
     * @param nmyUser 用户
     * @return 用户集合
     */
    public List<NmyUser> selectNmyUserList(NmyUser nmyUser);

    /**
     * 新增用户
     * 
     * @param nmyUser 用户
     * @return 结果
     */
    public int insertNmyUser(NmyUser nmyUser);

    /**
     * 修改用户
     * 
     * @param nmyUser 用户
     * @return 结果
     */
    public int updateNmyUser(NmyUser nmyUser);

    /**
     * 删除用户
     * 
     * @param id 用户主键
     * @return 结果
     */
    public int deleteNmyUserById(Long id);

    /**
     * 批量删除用户
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteNmyUserByIds(Long[] ids);
}
