package com.ruoyi.device.domain;

import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 设备对象 nmy_device
 * 
 * @author ruoyi
 * @date 2025-04-29
 */
@Data
public class NmyDevice extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    private Long id;

    /** 用户id */
    @Excel(name = "用户id")
    private Long userId;

    /** 设备唯一标识 */
    @Excel(name = "设备唯一标识")
    private String deviceFlag;

    /** 设备是否在线(0:不在线  1:在线) */
    @Excel(name = "设备是否在线(0:不在线  1:在线)")
    private String onLine;

    /** 设备登陆token值 */
    @Excel(name = "设备登陆token值")
    private String token;

    /** 设备ip */
    @Excel(name = "设备ip")
    private String deviceIp;


    @Excel(name = "服务器存储路径")
    private String serverPath;

    /** 删除标志（0代表存在 2代表删除） */
    private String delFlag;

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("userId", getUserId())
            .append("deviceFlag", getDeviceFlag())
            .append("onLine", getOnLine())
            .append("token", getToken())
            .append("deviceIp", getDeviceIp())
            .append("delFlag", getDelFlag())
            .append("createTime", getCreateTime())
            .append("updateTime", getUpdateTime())
            .toString();
    }
}
