package com.ruoyi.api.client;

import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.user.dto.LoginDto;
import com.ruoyi.user.dto.RegisterDto;
import com.ruoyi.user.service.LoginService;
import com.ruoyi.user.service.RegisterService;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

@RequestMapping("/api")
@RestController
public class LoginApi {

	@Resource(name = "ClientLoginService")
	private LoginService loginService;


	@Resource(name = "RegisterService")
	private RegisterService registerService;
	
	
	@PostMapping("/login")
	@ApiOperation("登陆接口")
	public AjaxResult login(@RequestBody LoginDto loginDto){
		//进行登陆
		AjaxResult login = loginService.login(loginDto);
		return login;
	}
	
	
	/**
	 * @param registerDto : 
	* @return com.ruoyi.common.core.domain.AjaxResult
	* @Version: v1.0
	* @Author: LiuYan
	* @Date 2025-5-5 12:22
	 * 
	 * 注册
	**/
	@PostMapping("/register")
	public AjaxResult register(@RequestBody RegisterDto registerDto){
		AjaxResult register = registerService.register(registerDto);
		return register;
	}
	
	
}
